DECLARE SUB STORE.RECALL.SET (SETNAME$)
DECLARE SUB PROGDEFALT (PRI%, SEC%, STORPATH$, WFMNAME$, SETNAME$)
DECLARE SUB WAIT.FOR.OPC (DIG!, OPC%)
DECLARE SUB WAIT.KEY (KEY$)
DECLARE SUB DOS.SHELL (PROMPT$)
DECLARE SUB C.DBL (N!, N#)
DECLARE SUB E.UNITS (N#, u$, n.e#, u.e$)
DECLARE SUB GRAPH.WFM (EGA%, WAVES.DEFINED!, WFM1%(), WFM2%(), xprec#, XI#, xo%, xu$, yi1#, prec1#, YO1%, yu1$, yi2#, prec2#, yo2%, yu2$, c1%, c2%, KEY$)
DECLARE SUB CLIP (AMIN%, invar%, AMAX%, outvar%)
DECLARE SUB ROUND (N#, p#)
DECLARE SUB GET.AVG.WFM ()
DECLARE SUB LOG.WFM (DIG!)
DECLARE SUB GND.REF (DIG!, YZ%)
DECLARE SUB SRQ (DIG!, STATUS%(), pause%)
DECLARE SUB GTL ()
DECLARE SUB SWAP.BYTES (test%())
DECLARE FUNCTION MIN% (WFM%(), MINLOC#)
DECLARE FUNCTION MAX% (WFM%(), MAXLOC#)
DECLARE SUB REMOVE.DEFECT (DIG)
DECLARE SUB SCALEWFM (YM!, YZ%, WFM!(), IWFM%())
DECLARE SUB DELAY (DELAYTIME!)
DECLARE SUB GNDREF (DIG, YZ%)
DECLARE SUB GETWFM (DIG, IWFM%(), MODE$, FLAG!)
DECLARE SUB GETSCALE (DIG, XI#, YM!, FLAG)
DECLARE FUNCTION GETANS$ (MES$)
DECLARE SUB PRESS.ANY.KEY (MES$)
DECLARE SUB GPIB.WRITE (DIG, MES$, FLAG!)
DECLARE SUB GPIB.READ (DIG, RD$, FLAG!)
DECLARE FUNCTION STR2NUM! (source$, SRCH$)
DECLARE FUNCTION GETNUM% (MES$)

' PROGRAM TO ACQUIRE, SCALE & GRAPH A WAVEFORM FROM 7912HB/7912AD
' PROGRAMMABLE DIGITIZER USING 7929P/7919P VERTICAL PLUG IN & THE
' 7B90P TIMEBASE PLUG IN.
'
'INSTRUMENT ADDRESS IS ASSUMED TO BE:
'       PRIMARY ADDRESS=0
'       SECONDARY ADDRESS=0
'
' BY: JOHN MCHUGH A.E. DIGITIZER MKTING
' DATE: 2/2/89
'
	COMMON SHARED /NISTATBLK/ IBSTA%, IBERR%, IBCNT%
	COMMON SHARED TRUE, FALSE, FLAG, DEBUG
	COMMON SHARED PRI%, SEC%, DIG, YM!, YZ%, XI#, WAVES.DEFINED, KEY$
	COMMON SHARED STORPATH$, filename$

	OPTION BASE 0
	DIM SHARED IWFM(0 TO 511) AS INTEGER
	DIM SHARED WFM(0 TO 511) AS SINGLE
	DIM SHARED STATUS(0 TO 2) AS INTEGER

RESTART:
	PRI% = 0                        'DEFAULT PRIMARY ADDRESS
	SEC% = 0                        'DEFAULT SECONDARY ADDRESS
	TRUE = 1                        'SET FLAG = TRUE MEANS FLAG=1
	FALSE = 0                       'SET FLAG = FALSE MEANS FLAG=0
	FLAG = 0                        'FLAG USED FOR ERROR HANDLING
	DEBUG = 0
	YZ% = -1                        'GROUND REF UNDEFINED=-1
	WAVES.DEFINED = 0               'INITIALLY NO WAVEFORMS DEFINED
	EGA% = 1                        'SET EGA%=0 FOR CGA TERMINAL
	STORPATH$ = "C:\"               'DEFAULT DRIVE TO STORE WFMS
	WFMNAME$ = "7912WFM"           'DEFAULT FILENAME FOR WFM STORAGE
	SETNAME$ = "7912SET"
	
	   
	ON ERROR GOTO General.error.handler

	CALL IBFIND("TEKDEV1", DIG)     'FIND 'TEKDEV1' IN GPIB.COM
	CALL IBPAD(DIG, PRI%)           'CHANGE PRIMARY ADDRESS
	CALL IBSAD(DIG, SEC% + 96)      'CHANGE SECONDARY ADDRESS
	CALL IBCLR(DIG)                 'SEND INTERFACE CLEAR TO CLEAN BUS
	CALL GPIB.WRITE(DIG, "opc on;XYZ ATC", FLAG)
MAINMENU:
	SCREEN 0
	CLS
	PRINT "                         *** 7912HB MAIN MENU ***"
	PRINT
	PRINT " 1. Store/Recall 7912HB/Vert & Timebase pluggin settings"
	PRINT " 2. Serial poll"
	PRINT " 3. Initialize 7912 (defect removal)"
	PRINT " 4. Enable/Disable ground reference"
	PRINT " 5. Acquire ATC waveform to memory"
	PRINT " 6. Acquire averaged waveform to memory"
	PRINT " 7. Graph waveform from memory with cursor measurements"
	'PRINT " 8. Data log waveform(s) to disk"
	PRINT " 8. DOS Shell"
	PRINT " 9. View/Edit program defaults"
	PRINT "10. Exit program"
	TMP = 0
	PRINT : TMP = GETNUM("Enter choice (1 to 10)")
	SELECT CASE TMP
	CASE 10
		GOTO THEEND
	CASE 1
		CALL STORE.RECALL.SET(SETNAME$)
	CASE 2
		CALL SRQ(DIG, STATUS%(), 1)
	CASE 3
		CALL REMOVE.DEFECT(DIG)
		CALL GPIB.WRITE(DIG, "XYZ ATC", FLAG)
	CASE 4
		CALL GND.REF(DIG, YZ%)
	CASE 5
		CALL PRESS.ANY.KEY("Ready to acquire a 7912HB ATC waveform")
		CALL GETSCALE(DIG, XI#, YM!, FLAG)
		PRINT "Reading a 512 point waveform"
		MODE$ = "MODE DIG;DIG DAT;ATC;READ ATC"
		CALL GETWFM(DIG, IWFM%(), MODE$, FLAG)
		FOR I% = 0 TO 511
		   IWFM%(I%) = IWFM%(I%) / 2 'divide values by 2 for atc wfm
		NEXT I%
		WAVES.DEFINED = 1
		'CALL SCALEWFM(YM!, yz%, WFM(), IWFM%())
	CASE 6
		NUMAVG% = -1
	   WHILE NUMAVG% < 0 OR NUMAVG% > 64
		N% = GETNUM%("Enter number of averages (1, 2, 4, 8, 16, 32 or 64, 0 to exit)")
		IF N% = 0 THEN GOTO MAINMENU
		IF N% <> 1 AND N% <> 2 AND N% <> 4 AND N% <> 8 AND N% <> 16 AND N% <> 32 AND N% <> 64 THEN
			NUMAVG% = -1
		ELSE
			NUMAVG% = N%
		END IF
	   WEND
		CALL GETSCALE(DIG, XI#, YM!, FLAG)
		PRINT "Reading a 512 point waveform averaged" + STR$(NUMAVG%) + " times";
		MODE$ = "MODE DIG;DIG SA," + MID$(STR$(NUMAVG%), 2, 4) + ";READ SA"
		CALL GETWFM(DIG, IWFM%(), MODE$, FLAG)
		FOR I% = 0 TO 511
		   IWFM%(I%) = IWFM%(I%) / NUMAVG% 'divide values by 2 for atc wfm
		NEXT I%
		WAVES.DEFINED = 1
		CALL GPIB.WRITE(DIG, "XYZ SA", FLAG)
		'CALL SCALEWFM(YM!, yz%, WFM(), IWFM%())
	CASE 7
	   IF WAVES.DEFINED > 0 THEN
		REDIM IWFM1%(1)
		xo% = 0
		xu$ = "Sec"
		IF YZ% > -1 THEN YO1% = YZ% ELSE Y01% = 0
		yu1$ = "V"
		CALL C.DBL(YM!, YI#)
		yi1# = YI#
		prec1# = 10# ^ (CINT(LOG(yi1#) / LOG(10#)) - 3#)
		CALL E.UNITS(yi1# * 1000#, yu1$, yi1.e#, yu1.e$)' use engineering units
		yi1.e# = yi1.e# / 1000#
		prec1.e# = prec1# * yi1.e# / yi1#
		xprec# = 10# ^ (CINT(LOG(XI#) / LOG(10#)) - 3#)
		CALL E.UNITS(XI# * 1000#, xu$, xi.e#, xu.e$)
		xi.e# = xi.e# / 1000#
		xprec.e# = xprec# * xi.e# / XI#
		yi2# = yi1#
		prec2# = prec1#
		yo2% = YO1%
		yu2$ = yu1$
		CALL GRAPH.WFM(EGA%, WAVES.DEFINED, IWFM%(), IWFM1%(), xprec.e#, xi.e#, xo%, xu.e$, yi1.e#, prec1.e#, YO1%, yu1.e$, yi2#, prec2#, yo2%, yu2$, c1%, c2%, KEY$)
		ELSE
		CALL PRESS.ANY.KEY("No waveforms acquired yet")
		END IF
	'IF A = 8 THEN CALL LOG.WFM(DIG)
	CASE 8
		CALL DOS.SHELL("7912HB program")
	CASE 9
		CALL PROGDEFALT(PRI%, SEC%, STORPATH$, WFMNAME$, SETNAME$)
	   
	CASE ELSE
		CALL PRESS.ANY.KEY("Selection out of range")
	   
	END SELECT
		GOTO MAINMENU

THEEND:  PRINT : PRINT "Program ended. "
	 END

General.error.handler:
	SCREEN 0
	CLS
	PRINT "Unexpected Error #"; ERR
	PRINT
	PRINT "Please try to document the sequence of operations and conditions"
	PRINT "which led to this error.  This information is extremely valuable"
	PRINT "in trying to correct programming problems."
	PRINT
	PRINT "Address comments, suggestions, examples and questions to:"
	PRINT
	PRINT "   John McHugh"
	PRINT "   Senior Applications Engineer"
	PRINT "   Tektronix, Inc."
	PRINT "   P.O. Box 3500"
	PRINT "   Vancouver, WA  98668"
	PRINT
	PRINT "Thank you for your patience and assistance."
	PRINT "Press any key to restart the program..."

	WHILE INKEY$ > ""
	WEND
	DO
	LOOP UNTIL INKEY$ > ""
	RESUME RESTART

SUB C.DBL (N!, N#) STATIC    ' same as CDBL but without the noise bits

	N$ = STR$(N!)
	p% = INSTR(N$, "E")
	IF p% > 0 THEN
		MID$(N$, p%) = "D"
	ELSE
		range$ = range$ + "#"
	END IF
	N# = VAL(N$)

END SUB

SUB CLIP (AMIN%, invar%, AMAX%, outvar%) STATIC

	outvar% = invar%
	IF outvar% < AMIN% THEN outvar% = AMIN%
	IF outvar% > AMAX% THEN outvar% = AMAX%

END SUB

SUB DELAY (DELAYTIME!)
'SUB TO DELAY A SPECIFIC AMOUNT OF TIME
	START! = TIMER
	FINISH! = START! + DELAYTIME!
	IF DEBUG THEN PRINT "DELAYING"; DELAYTIME!; "SECS"
	DO
		DOTIME! = TIMER
	LOOP WHILE FINISH! - DOTIME! > 0
END SUB

SUB DISPLAY
Display.wave:
	'CALL Parse(wfmpre1$, nr.pt#, xi#, xo, xu$, yi1#, prec1#, yo1%, yu1$)
	yi1# = yi1# * MULTIPLIER.CH1#
	prec1# = prec1# * MULTIPLIER.CH1#
	yu1$ = UNITS.CH1$
	CALL E.UNITS(yi1# * 1000#, yu1$, yi1.e#, yu1.e$)' use engineering units
	yi1.e# = yi1.e# / 1000#
	prec1.e# = prec1# * yi1.e# / yi1#
	IF WAVES.DEFINED = 2 THEN
		''CALL Parse(wfmpre2$, nr.pt#, xi#, xo, xu$, yi2#, prec2#, yo2, yu2$)
		yi2# = yi2# * MULTIPLIER.CH2#
		prec2# = prec2# * MULTIPLIER.CH2#
		yu2$ = UNITS.CH2$
		CALL E.UNITS(yi2# * 1000#, yu2$, yi2.e#, yu2.e$)
		yi2.e# = yi2.e# / 1000#
		prec2.e# = prec2# * yi2.e# / yi2#
	END IF
	CALL E.UNITS(XI# * 1000#, xu$, xi.e#, xu.e$)
	xi.e# = xi.e# / 1000#
	'CALL Graph.wfm(EGAFLAG, waves.defined, xi.e#, xo, xu.e$, yi1.e#, prec1.e#, yo1, yu1.e$, yi2.e#, prec2.e#, yo2, yu2.e$, c1, c2, key$)
	SCREEN 0: CLS

END SUB

SUB DOS.SHELL (PROMPT$)
	CLS
	PRINT "Type 'EXIT' to return to " + PROMPT$
	SHELL
END SUB

SUB E.UNITS (N#, u$, n.e#, u.e$) STATIC

' Adjust n# and u$ by applying engineering units: p n u m K M G

	IF N# <= .000000001# THEN
		n.e# = N# * 1000000000000#
		u.e$ = "p" + u$

	ELSEIF N# <= .000001# THEN
		n.e# = N# * 1000000000#
		u.e$ = "n" + u$

	ELSEIF N# <= .001# THEN
		n.e# = N# * 1000000#
		u.e$ = "u" + u$

	ELSEIF N# <= 1 THEN
		n.e# = N# * 1000#
		u.e$ = "m" + u$

	ELSEIF N# >= 1000# THEN
		n.e# = N# / 1000#
		u.e$ = "K" + u$

	ELSEIF N# >= 1000000# THEN
		n.e# = N# / 1000000#
		u.e$ = "M" + u$

	ELSEIF N# >= 1000000000# THEN
		n.e# = N# / 1000000000#
		u.e$ = "G" + u$
	ELSE
		n.e# = N#
		u.e$ = u$
	END IF

END SUB

FUNCTION GETANS$ (MES$)
	ans$ = SPACE$(1)
AGAIN:
	PRINT : PRINT MES$ + " (Y/N)";
	INPUT ans$
	ans$ = UCASE$(ans$)
	IF ans$ <> "N" AND ans$ <> "Y" THEN GOTO AGAIN
	GETANS$ = ans$
END FUNCTION

FUNCTION GETNUM% (MES$)
BADNUM:
	PRINT : PRINT MES$ + ": ";
	INPUT a$
	a$ = a$ + "-99"
	a% = VAL(a$)
	IF a% = -99 THEN GOTO BADNUM
	GETNUM% = a%
END FUNCTION

SUB GETSCALE (DIG, XI#, YM!, FLAG)
' SUB TO QUERY THE MAINFRAME FOR THE VERTICAL & HORIZONTAL SCALE FACTORS
'
	PRINT "Reading scale factors"
	MES$ = "VS1?"
	GOSUB GETSFCTR
	YM! = ans# / 64!                  '64 LEVELS PER DIVISION (512/
	   
	MES$ = "HS1?"
	GOSUB GETSFCTR
	XI# = ans# / 51.2                 '51.2 POINTS PER DIV (512/10 DIV)
	EXIT SUB

GETSFCTR:
	TMP$ = SPACE$(30)
	CALL GPIB.WRITE(DIG, MES$, FLAG)
	CALL GPIB.READ(DIG, TMP$, FLAG)
	a = INSTR(TMP$, " ")
	RD$ = MID$(TMP$, a, 15)
	ans# = VAL(RD$)
	IF DEBUG THEN CALL PRESS.ANY.KEY(RD$ + "," + STR$(ans#))
	RETURN

END SUB

SUB GETWFM (DIG, IWFM%(), MODE$, FLAG) STATIC

' Reads 7912HB/AD waveform into an integer array iwfm()

	CNT% = 1024
	CALL IBSAD(DIG, SEC% + 96)      'CHANGE SECONDARY ADDRESS
	HEADER$ = SPACE$(3)
	CHECKSUM$ = SPACE$(4)
	   
	CALL GPIB.WRITE(DIG, MODE$, FLAG)
	OPC% = 0
	WHILE OPC% < 1
		CALL WAIT.FOR.OPC(DIG, OPC%)                   'wait till ready to send
	WEND
	IF FLAG = FALSE THEN GOTO read.curve.error

	CALL GPIB.READ(DIG, HEADER$, FLAG)              ' read %bc
	IF IBSTA% < 0 THEN GOTO read.curve.error

	CALL IBRDI(DIG, IWFM%(), CNT%)                  ' READ CURVE
	IF IBSTA% < 0 THEN GOTO read.curve.error
	
	CALL IBRD(DIG, CHECKSUM$)                       ' read checksum ; <lf>
	IF IBSTA% < 0 THEN GOTO read.curve.error
	   
	CALL SWAP.BYTES(IWFM%())        ' swap high and low data bytes
	FLAG = TRUE
EXIT SUB
read.curve.error:
	FLAG = FALSE
	CALL PRESS.ANY.KEY("GPIB error reading waveform, IBSTA=$" + HEX$(IBSTA%) + ", IBERR=" + STR$(IBERR%) + ", IBCNT=" + STR$(IBCNT%))
	IBERR% = 0
END SUB

SUB GND.REF (DIG, YZ%)
	ans$ = GETANS$("Define & use a ground reference for all subsequent acquisitions")
	IF ans$ = "Y" THEN
		PRINT : PRINT "Reading ground reference.....";
		CPL$ = SPACE$(20)
		MOD$ = SPACE$(20)
		MAI$ = SPACE$(20)
		CALL IBSAD(DIG, 97 + SEC%)              'SET SECONDARY ADDRESS TO VERT PLUG
		CALL GPIB.WRITE(DIG, "CPL?", FLAG)      'LEARN VERTICAL COUPLING
		CALL GPIB.READ(DIG, CPL$, FLAG)
		CPL$ = RTRIM$(CPL$)
		CALL GPIB.WRITE(DIG, "CPL GND", FLAG)   'GROUND VERTICAL PLUGIN
		  
		CALL IBSAD(DIG, 98 + SEC%)              'SET SECONDARY ADDRESS TO TIMEBASE PLUG
		CALL GPIB.WRITE(DIG, "MOD?", FLAG)      'LEARN VERTICAL COUPLING
		CALL GPIB.READ(DIG, MOD$, FLAG)
		MOD$ = RTRIM$(MOD$)
		CALL GPIB.WRITE(DIG, "MOD PPA", FLAG)   'SET TO PK-PK AUTO TRIGGER
		CALL DELAY(.5)                          'WAIT 100 mS
		  
		CALL IBSAD(DIG, 96 + SEC%)              'SET SECONDARY ADDRESS TO MAINFRAME
		CALL GPIB.WRITE(DIG, "MAI?", FLAG)
		CALL GPIB.READ(DIG, MAI$, FLAG)
		CALL GETWFM(DIG, IWFM%(), "MODE DIG;DIG DAT;ATC;READ ATC", FLAG)        'READ GND WAVEFORM
		  
		TMP% = 0                                'FIND MEAN OF 1ST 20 POINTS
		FOR I% = 1 TO 20
		TMP% = TMP% + IWFM%(I%)
		NEXT I%

		YZ% = TMP% / 20                         'YZ% IS GROUND REFERENCE
		YZ% = YZ% / 2                           'ATC WFM /2
		   
		CALL IBSAD(DIG, 97 + SEC%)              'SET SECONDARY ADDRESS TO VERTICAL PLUG
		CALL GPIB.WRITE(DIG, CPL$, FLAG)        'RESET COUPLING
		CALL IBSAD(DIG, 98 + SEC%)              'SET SECONDARY ADDRESS TO TIMEBASE PLUG
		CALL GPIB.WRITE(DIG, MOD$, FLAG)        'RESET TIMEBASE TRIGGER MODE
		CALL DELAY(1)
		CALL IBSAD(DIG, 96 + SEC%)
		
	ELSE
		YZ = -1                                 'NO GROUND REFERENCE
	END IF

	IF YZ% = -1 THEN TMP$ = "disabled" ELSE TMP$ = "enabled"
	CALL PRESS.ANY.KEY("Ground reference is " + TMP$)
	CALL GPIB.WRITE(DIG, MAI$ + "MODE DIG;DIG DAT;ATC;XYZ ATC", FLAG)
END SUB

SUB GPIB.READ (DIG, RD$, FLAG)
	CALL IBRD(DIG, RD$)
	IF IBSTA% < 0 THEN
		FLAG = FALSE
		CALL PRESS.ANY.KEY("GPIB error on read, IBSTA=$" + HEX$(IBSTA%) + ", IBERR=" + STR$(IBERR%) + ", IBCNT=" + STR$(IBCNT%))
		IBERR% = 0
	ELSE
		FLAG = TRUE
	END IF
END SUB

SUB GPIB.WRITE (DIG, MES$, FLAG)
	CALL ibwrt(DIG, MES$)
	IF IBSTA% < 0 THEN
		FLAG = FALSE
		CALL PRESS.ANY.KEY("GPIB error on write, IBSTA=$" + HEX$(IBSTA%) + ", IBERR=" + STR$(IBERR%) + ", IBCNT=" + STR$(IBCNT%))
		IBERR% = 0
	ELSE
		FLAG = TRUE
	END IF
END SUB

SUB GRAPH.WFM (EGA%, WAVES.DEFINED, WFM1%(), WFM2%(), xprec#, XI#, xo%, xu$, yi1#, prec1#, YO1%, yu1$, yi2#, prec2#, yo2%, yu2$, c1%, c2%, KEY$) STATIC

	SCREEN 0: CLS
	PRINT "Position the CURSORS to set the time window for analysis:"
	PRINT
	PRINT "       F1 - Select CURSOR 1"
	PRINT "       F2 - Select CURSOR 2"
	PRINT "       F3 - Hide CURSORS"
	PRINT
	PRINT "       "; CHR$(27); CHR$(26); " - Move the selected CURSOR by 1 point"
	PRINT "       "; CHR$(24); CHR$(25); " - Move the selected CURSOR by 10 points"
	PRINT "PgUp PgDn - Move the selected CURSOR by 100 points"
	PRINT " Home End - Move the selected CURSOR to beginning or end"
	PRINT
	PRINT "    Enter - Return to main menu"
	PRINT
	PRINT "      ESC - Return to main menu"
	PRINT
	PRINT "        z - Zoom time zone"
	PRINT "        w - Whole time zone"
	PRINT "        d - Dots"
	PRINT "        v - Vectors"

	CALL PRESS.ANY.KEY("Ready to graph waveform")
	IF KEY$ = CHR$(27) THEN EXIT SUB

	f% = 1    ' frame                        blue
	h% = 2    ' horizontal scale             green
	v1% = 14  ' WFM1 vert.scale and trace    yellow
	c11% = 4  ' cursor 1 WFM1                red
	c21% = 6  ' cursor 2 WFM1                brown
	v2% = 11  ' WFM2 vert.scale and trace    light cyan
	c12% = 3  ' cursor 1 WFM2                cyan
	c22% = 5  ' cursor 2 WFM2                magenta
	AMAX% = 511
	AMIN% = 0
	TAMIN% = MIN%(IWFM%(), MINLOC#)
	   
	TAMAX% = MAX%(IWFM%(), MAXLOC#)
	first% = LBOUND(WFM1%)          ' WFM1%() is same size and timebase as WFM2%
	last% = UBOUND(WFM1%)


' DIM ARRAYS FOR CURSOR BAR GRAPHIC IMAGES

	DIM xcrsr1%(559)   ' cursor1 time
	DIM ycrsr11%(127)  ' cursor1 WFM1
	DIM ycrsr12%(127)  ' cursor1 WFM2
	DIM xcrsr2%(559)   ' cursor2 time
	DIM ycrsr21%(127)  ' cursor2 WFM1
	DIM ycrsr22%(127)  ' cursor2 WFM2
	   
	IF EGA% THEN
		SCREEN 9: CLS 0
		vpix% = 14
		VIEW (70, 2.5 * vpix%)-(570, 22.5 * vpix%), , f%
	ELSE
		SCREEN 2: CLS 0
		vpix% = 8
		VIEW (70, 2.5 * vpix%)-(570, 22.5 * vpix%), , 1
	END IF
	   
	y.div# = (AMAX% - AMIN%) / 5          ' 5 vertical divisions for tics and labeling
	
	c1% = first%   ' initialize csrs1 to first point
	c2% = last%    '            crsr2 to last point
	cn% = 1        '            csrs1 is the one that moves

Zoom.loop:  ' z for time zoom, no vertical zoom (yet...)

	x.div# = (last% - first% + 1) / 5.12    ' 5 horizontal divisions

	WINDOW (first%, AMIN% - 3)-(last%, AMAX% + 3) ' scale graphics to WFM1%()
	CLS 1

' GET CURSOR BAR GRAPHIC IMAGES INTO ARRAYS

	IF EGA% THEN COLOR h%, 0
	LINE (first%, AMIN%)-(first%, AMAX%), , , &HF0F0       'use &Hxxxx to prevent
	GET (first%, AMIN% + 5)-(first%, AMAX% - 5), xcrsr1%
	LINE (first%, AMIN%)-(first%, AMAX%), 0

	LINE (first%, AMIN%)-(first%, AMAX%), , , &HF0F        'cursors from clashing
	GET (first%, AMIN% + 5)-(first%, AMAX% - 5), xcrsr2%
	LINE (first%, AMIN%)-(first%, AMAX%), 0

	IF EGA% THEN COLOR c11%, 0
	LINE (first%, AMIN%)-(last%, AMIN%), , , &HF000        'with each other when
	GET (first% + 5, AMIN%)-(last% - 5, AMIN%), ycrsr11%
	LINE (first%, AMIN%)-(last%, AMIN%), 0

	IF EGA% THEN COLOR c21%, 0
	LINE (first%, AMIN%)-(last%, AMIN%), , , &HF0          'they happen to overlap
	GET (first% + 5, AMIN%)-(last% - 5, AMIN%), ycrsr21%
	LINE (first%, AMIN%)-(last%, AMIN%), 0

	IF EGA% THEN COLOR c12%, 0
	LINE (first%, AMIN%)-(last%, AMIN%), , , &HF00         'Otherwise XOR makes
	GET (first% + 5, AMIN%)-(last% - 5, AMIN%), ycrsr12%
	LINE (first%, AMIN%)-(last%, AMIN%), 0

	IF EGA% THEN COLOR c22%, 0
	LINE (first%, AMIN%)-(last%, AMIN%), , , &HF           'crazy colors...
	GET (first% + 5, AMIN%)-(last% - 5, AMIN%), ycrsr22%
	LINE (first%, AMIN%)-(last%, AMIN%), 0

	left.tic% = first% + (last% - first%) / 100
	right.tic% = last% - (last% - first%) / 100

' draw and label vert.divs. (below ground) on left for WFM1%()

	IF EGA% THEN COLOR v1%, 0
	LOCATE 1, 1: PRINT LEFT$(yu1$, 8);                        ' VERT.UNITS

IF YZ% > -1 THEN
	FOR I# = YO1% TO AMIN% STEP -y.div#
		IF I# <= AMAX% AND I# >= AMIN% THEN
			LINE (first%, I#)-(left.tic%, I#)               ' vert.div.s
			LINE (right.tic%, I#)-(last%, I#)
			row% = INT(PMAP(I# - vpix% / 2, 1) / vpix%) + 3
			LOCATE row%, 1
			DIV# = (I# - YO1%) * yi1#
			CALL ROUND(DIV#, prec1#)
			GOSUB roundit
			PRINT RIGHT$(SPACE$(8) + DIV$, 8);               ' vert.labels
		END IF
	NEXT I#
END IF
' draw and label vert.divs. (above ground) on left for WFM1%()

	FOR I# = YO1% TO AMAX% STEP y.div#
		IF I# <= AMAX% AND I# >= AMIN% THEN
			LINE (first%, I#)-(left.tic%, I#)
			LINE (right.tic%, I#)-(last%, I#)
			row% = INT(PMAP(I# - vpix% / 2, 1) / vpix%) + 3
			LOCATE row%, 1
			IF YZ% > -1 THEN
				DIV# = (I# - YO1%) * yi1#
			ELSE
				DIV# = I# * yi1#
			END IF
			CALL ROUND(DIV#, prec1#)
			GOSUB roundit
			PRINT RIGHT$(SPACE$(8) + DIV$, 8);
		END IF
	NEXT I#

' draw and label vert.divs. (below ground) on right for WFM2%()

IF WAVES.DEFINED = 2 THEN
	IF EGA% THEN COLOR v2%, 0
	LOCATE 2, 73: PRINT LEFT$(yu2$, 8);                     ' VERT.UNITS

	FOR I# = yo2% TO AMIN% STEP -y.div#
		IF I# <= AMAX% AND I# >= AMIN% THEN
			LINE (first%, I#)-(left.tic%, I#)
			LINE (right.tic%, I#)-(last%, I#)
			row% = INT(PMAP(I# - vpix% / 2, 1) / vpix%) + 3
			LOCATE row%, 73
			DIV# = (I# - yo2%) * yi2#
			CALL ROUND(DIV#, prec2#)
			GOSUB roundit
			PRINT LEFT$(DIV$, 8);
		END IF
	NEXT I#

' draw and label vert.divs. (above ground) on right for WFM2%()

	FOR I# = yo2% TO AMAX% STEP y.div#
		IF I# <= AMAX% AND I# >= AMIN% THEN
			LINE (first%, I#)-(left.tic%, I#)
			LINE (right.tic%, I#)-(last%, I#)
			row% = INT(PMAP(I# - vpix% / 2, 1) / vpix%) + 3
			LOCATE row%, 73
			DIV# = (I# - yo2%) * yi2#
			CALL ROUND(DIV#, prec2#)
			GOSUB roundit
			PRINT LEFT$(DIV$, 8);
		END IF
	NEXT I#
END IF

' draw and label horizontal scale

	IF EGA% THEN COLOR h%, 0
	LOCATE 24, 1: PRINT SPACE$(79);
	LOCATE 25, 73: PRINT LEFT$(xu$, 8);                  ' HORIZ.UNITS

IF xo% < 0 THEN
' pre-trigger
	FOR I# = xo% TO first% STEP -x.div#
		IF I# >= first% AND I# <= last% THEN
			LINE (I#, AMIN%)-(I#, AMAX% / 100)             ' h.div.s
			LINE (I#, AMAX% / 100 * 99)-(I#, AMAX%)
			x% = CINT(PMAP(I#, 0) / 8) + 8
			LOCATE 24, x%
			DIV# = (I# - xo%) * XI#
			'CALL round(div#, xi#)
			CALL ROUND(DIV#, xprec#)
			GOSUB roundit
			PRINT DIV$;                                ' h.labels
		END IF
	NEXT I#
END IF
' post-trigger
	FOR I# = xo% TO last% STEP x.div#
		IF I# >= first% AND I# <= last% THEN
			LINE (I#, AMIN%)-(I#, AMAX% / 100)
			LINE (I#, AMAX% / 100 * 99)-(I#, AMAX%)
			x% = CINT(PMAP(I#, 0) / 8) + 8
			LOCATE 24, x%
			DIV# = (I# - xo%) * XI#
			CALL ROUND(DIV#, xprec#)
			'CALL round(div#, xi#)
			DIV$ = STR$(DIV#)
			GOSUB roundit
			PRINT DIV$;
		END IF
	NEXT I#

' PLOT WFM1%()

	IF EGA% THEN COLOR v1%, 0
	IF VECTORS THEN
		PSET (first%, WFM1%(first%))
		FOR I% = first% TO last%
			LINE -(I%, WFM1%(I%))         ' VECTORS
		NEXT I%
	ELSE                                    ' or
		PSET (first%, WFM1%(first%))
		FOR I% = first% TO last%
			PSET (I%, WFM1%(I%))          ' dots
		NEXT I%
	END IF

' PLOT WFM2%()

	IF WAVES.DEFINED = 2 THEN
		IF EGA% THEN COLOR v2%, 0
		IF VECTORS THEN
			PSET (first%, WFM2%(first%))
			FOR I% = first% TO last%
				LINE -(I%, WFM2%(I%))
			NEXT I%
		ELSE
			PSET (first%, WFM2%(first%))
			FOR I% = first% TO last%
				PSET (I%, WFM2%(I%))
			NEXT I%
		END IF
	END IF

	GOSUB Crsr1.on
	GOSUB Crsr2.on

	DO
		Update = TRUE
		DO
			KEY$ = INKEY$
			KEY$ = UCASE$(KEY$)
			IF KEY$ = "" AND Update = TRUE THEN
				GOSUB Update.cursors
				Update = FALSE
			END IF
		LOOP UNTIL KEY$ <> ""
' z=ZOOM
		IF KEY$ = "Z" THEN
			IF c1% > last% - 100 THEN
				IF c1% > UBOUND(WFM1%) - 100 THEN
					c1% = UBOUND(WFM1%) - 100
				END IF
				c2% = c1% + 100
			ELSEIF c2% < first% + 100 THEN
				IF c2% < LBOUND(WFM1%) + 100 THEN
					c2% = LBOUND(WFM1%) + 100
				END IF
				c1% = c2% - 100
			ELSEIF c2% < c1% + 100 THEN
				c2% = c1% + 100
			END IF
			first% = c1%
			last% = c2%
			EXIT DO
		END IF
'w=whole
		IF KEY$ = "W" THEN
			first% = LBOUND(WFM1%)                 ' restore entire
			last% = UBOUND(WFM1%)                  ' time window
			EXIT DO
		END IF
'v=VECTORS
		IF KEY$ = "V" AND VECTORS <> TRUE THEN
			VECTORS = TRUE
			EXIT DO
		END IF
'd=dots
		IF KEY$ = "D" AND VECTORS = TRUE THEN
			VECTORS = FALSE
			EXIT DO
		END IF

' cursor keys
		IF LEFT$(KEY$, 1) = CHR$(0) THEN
			IF cn% = 1 THEN
				GOSUB Crsr1.off
				C% = c1%
				llimit% = first%
				rlimit% = c2% - 1
			ELSEIF cn% = 2 THEN
				GOSUB Crsr2.off
				C% = c2%
				llimit% = c1% + 1
				rlimit% = last%
			END IF
			KEY$ = MID$(KEY$, 2)
			SELECT CASE KEY$
				CASE "M"                                       ' right arrow
					CALL CLIP(llimit%, (C% + 1), rlimit%, C%)
				CASE "K"                                       ' left arrow
					CALL CLIP(llimit%, (C% - 1), rlimit%, C%)
				CASE "P"   '                                   ' down arrow
					CALL CLIP(llimit%, (C% + 10), rlimit%, C%)
				CASE "H"                                       ' up arrow
					CALL CLIP(llimit%, (C% - 10), rlimit%, C%)
				CASE "Q"                                       ' page down
					CALL CLIP(llimit%, (C% + 100), rlimit%, C%)
				CASE "I"                                       ' page up
					CALL CLIP(llimit%, (C% - 100), rlimit%, C%)
				CASE "O"                                       ' end
					C% = rlimit%
				CASE "G"                                       ' home
					C% = llimit%
				CASE ";"                                       ' f1
					IF cn% = 0 THEN
						GOSUB Crsr2.on
					ELSEIF cn% = 2 THEN
						GOSUB Crsr2.on
						GOSUB Crsr1.off
					END IF
					cn% = 1
					C% = c1%
				CASE "<"                                       ' f2
					IF cn% = 0 THEN
						GOSUB Crsr1.on
					ELSEIF cn% = 1 THEN
						GOSUB Crsr1.on
						GOSUB Crsr2.off
					END IF
					cn% = 2
					C% = c2%
				CASE "="                                       ' f3
					IF cn% = 1 THEN
						GOSUB Crsr2.off
					ELSEIF cn% = 2 THEN
						GOSUB Crsr1.off
					END IF
					cn% = 0            ' hide cursors
				CASE ELSE
			END SELECT
			IF cn% = 1 THEN
				c1% = C%
				GOSUB Crsr1.on
			ELSEIF cn% = 2 THEN
				c2% = C%
				GOSUB Crsr2.on
			END IF
		END IF
	LOOP UNTIL KEY$ = CHR$(27) OR KEY$ = CHR$(13)
	IF KEY$ <> CHR$(27) AND KEY$ <> CHR$(13) THEN GOTO Zoom.loop
	ERASE xcrsr1%, ycrsr11%, ycrsr21%, ycrsr12%, ycrsr22%

EXIT SUB

Crsr1.on:
	PUT (c1%, AMIN% + 5), xcrsr1%, XOR                 ' cursor1 time
	PUT (first% + 5, WFM1%(c1%)), ycrsr11%, XOR     ' cursor1 WFM1
	IF WAVES.DEFINED = 2 THEN
		PUT (first% + 5, WFM2%(c1%)), ycrsr12%, XOR' cursor1 WFM2
	END IF
RETURN

Crsr2.on:
	PUT (c2%, AMIN% + 5), xcrsr2%, XOR                 ' cursor2 time
	PUT (first% + 5, WFM1%(c2%)), ycrsr21%, XOR     ' cursor2 WFM1
	IF WAVES.DEFINED = 2 THEN
		PUT (first% + 5, WFM2%(c2%)), ycrsr22%, XOR' cursor2 WFM2
	END IF
RETURN

Crsr1.off:
	IF WAVES.DEFINED = 2 THEN
		PUT (first% + 5, WFM2%(c1%)), ycrsr12%, XOR' cursor1 WFM2
	END IF
	PUT (first% + 5, WFM1%(c1%)), ycrsr11%, XOR     ' cursor1 WFM1
	PUT (c1%, AMIN% + 5), xcrsr1%, XOR                 ' cursor1 time
RETURN

Crsr2.off:
	IF WAVES.DEFINED = 2 THEN
		PUT (first% + 5, WFM2%(c2%)), ycrsr22%, XOR' cursor2 WFM2
	END IF
	PUT (first% + 5, WFM1%(c2%)), ycrsr21%, XOR     ' cursor2 WFM1
	PUT (c2%, AMIN% + 5), xcrsr2%, XOR                 ' cursor2 time
RETURN


Update.cursors:

	SPACE10$ = SPACE$(10)

	c11# = (WFM1%(c1%) - YO1%) * yi1#           ' cursor1 WFM1
	c21# = (WFM1%(c2%) - YO1%) * yi1#           ' cursor2 WFM1
	CALL ROUND(c11#, prec1#)
	CALL ROUND(c21#, prec1#)
	c1d# = c21# - c11#
	CALL ROUND(c1d#, prec1#)
	   
	LOCATE 1, 10
	IF EGA% THEN COLOR c11%, 0
	DIV# = c11#
	GOSUB roundit
	PRINT "CRSR1:"; LEFT$(DIV$ + SPACE10$, 10);
	LOCATE 1, 33
	IF EGA% THEN COLOR c21%, 0
	DIV# = c21#
	GOSUB roundit
	PRINT "CRSR2:"; LEFT$(DIV$ + SPACE10$, 10);
	LOCATE 1, 56
	IF EGA% THEN COLOR v1%, 0
	DIV# = c1d#
	GOSUB roundit
	PRINT "DELTA:"; LEFT$(DIV$ + SPACE10$, 10);

IF WAVES.DEFINED = 2 THEN
	c12# = (WFM2%(c1%) - yo2%) * yi2#            ' cursor1 WFM2
	c22# = (WFM2%(c2%) - yo2%) * yi2#            ' cursor2 WFM2
	CALL ROUND(c12#, prec2#)
	CALL ROUND(c22#, prec2#)
	c2d# = c22# - c12#
	CALL ROUND(c2d#, prec2#)
	LOCATE 2, 10
	IF EGA% THEN COLOR c12%, 0
	DIV# = c12#
	GOSUB roundit
	PRINT "CRSR1:"; LEFT$(DIV$ + SPACE10$, 10);
	LOCATE 2, 33
	IF EGA% THEN COLOR c22%, 0
	DIV# = c22#
	GOSUB roundit
	PRINT "CRSR2:"; LEFT$(DIV$ + SPACE10$, 10);
	LOCATE 2, 56
	IF EGA% THEN COLOR v2%, 0
	DIV# = c2d#
	GOSUB roundit
	PRINT "DELTA:"; LEFT$(DIV$ + SPACE10$, 10);
END IF

	c31# = (c1% - xo%) * XI#                           ' time cursors
	c32# = ((c2% - xo%) * XI#) + XI#
	CALL ROUND(c31#, XI#)
	CALL ROUND(c32#, XI#)
	c3d# = c32# - c31#
	CALL ROUND(c3d#, XI#)
	IF EGA% THEN COLOR h%, 0
	LOCATE 25, 10
	DIV# = c31#
	GOSUB roundit
	PRINT "CRSR1:"; LEFT$(DIV$ + SPACE10$, 10);
	LOCATE 25, 33
	DIV# = c32#
	GOSUB roundit
	PRINT "CRSR2:"; LEFT$(DIV$ + SPACE10$, 10);
	LOCATE 25, 56
	DIV# = c3d#
	GOSUB roundit
	PRINT "DELTA:"; LEFT$(DIV$ + SPACE10$, 10);

	RETURN
roundit:
	DIV$ = STR$(DIV#)
	p = INSTR(DIV$, ".")
	IF p > 0 THEN
	   TMP$ = MID$(DIV$, 1, p)
	   tmp1$ = MID$(DIV$, p + 1, 3)
	   DIV$ = TMP$ + tmp1$
	END IF
RETURN


END SUB

SUB GTL
' Sub to put 7912 mainframe & pluggins in local state
' Assumes that variable DIG has been previously using IBFIND
' and the primary address is correct (use IBPAD to set primary address)

' Example: 7912HB at primary address 5
' Call IBFIND("TEKDEV1", DIG)  'Assumes a device named 'TEKDEV1' in GPIB.COM
' Call IBPAD(DIG,5) 'Set primary address to 5

	FOR I% = 0 TO 2
		CALL IBSAD(DIG, 96 + I%)
		CALL IBLOC(DIG)
	NEXT I%
		CALL IBFIND("GPIB0", BD%)
		CALL IBSRE(BD%, 0)
END SUB

SUB LOG.WFM (DIG)
' SUB TO LOG WAVEFORMS TO A FILE FOR LATER ANALYSIS
   filename$ = STORPATH$ + WFMNAME$
   filenum% = 0
WHILE filenum% < 1 OR filenum% > 100
   filenum% = GETNUM%("Enter starting file number to log waveform to (1 to 100)")
WEND
   goon = 1
   WHILE goon = 1
	CALL IBSAD(DIG, 98 + SEC%)
	CALL GPIB.WRITE(DIG, "MOD SSW;SSW ARM", FLAG)
	CALL IBSAD(DIG, 96 + SEC%)
	CALL GPIB.WRITE(DIG, "MODE DIG;DIG SSW;ATC;READ ATC", FLAG)
	tfilename$ = filename$ + MID$(STR$(filenum%), 2, 4)
	PRINT "Press <Esc> to exit data log"
	PRINT "Waiting for trigger...";
	OPC% = 0
	WHILE OPC% < 1
		KEY$ = INKEY$
		IF KEY$ = CHR$(27) THEN EXIT SUB
		CALL WAIT.FOR.OPC(DIG, OPC%)
	WEND
	PRINT "got it, saving data"
	CALL ibrdf(DIG, tfilename$)
	filenum% = filenum% + 1
   WEND

END SUB

FUNCTION MAX% (IWFM%(), MAXLOC#)
'FUNCTION TO FIND MAXIMUM OF AN ARRAY
	first% = LBOUND(IWFM%)
	last% = UBOUND(IWFM%)
	TMAX% = IWFM%(first%)
	MAXLOC# = first%
	FOR I% = first% + 1 TO last%
	   IF IWFM%(I%) > TMAX% THEN
		TMAX% = IWFM%(I%)
		MAXLOC# = I%
	   END IF
	NEXT I%
	MAX% = TMAX%
END FUNCTION

FUNCTION MIN% (IWFM%(), MINLOC#)
'FUNCTION TO FIND MINIMUM OF AN ARRAY
	first% = LBOUND(IWFM%)
	last% = UBOUND(IWFM%)
	TMIN% = IWFM%(first%)
	MINLOC# = first%
	FOR I% = first% + 1 TO last%
	   IF IWFM%(I%) < TMIN% THEN
		TMIN% = IWFM%(I%)
		MINLOC# = I%
	   END IF
	NEXT I%
	MIN% = TMIN%
END FUNCTION

SUB PRESS.ANY.KEY (MES$)
	PRINT : PRINT MES$
	PRINT "Press <Space Bar> to continue"
	CALL WAIT.KEY(KEY$)
END SUB

SUB PROGDEFALT (PRI%, SEC%, STORPATH$, WFMNAME$, SETNAME$)
prog1:
IN% = -1
WHILE IN% < 0 OR IN% > 6
	CLS
	PRINT "                 ** 7912HB PROGRAM DEFAULTS **": PRINT
	PRINT "1. 7912HB primary address, currently:" + STR$(PRI%)
	PRINT "2. 7912HB secondary address, currently:" + STR$(SEC%)
	PRINT "3. Disk storage path, currently: " + STORPATH$
	PRINT "4. Disk waveform storage filename, currently: " + WFMNAME$
	PRINT "5. Disk settings filename, currently: " + SETNAME$
	PRINT "6. EXIT to MAIN MENU"
	PRINT
	INPUT "Enter selection, <Enter> for main menu:", IN%
WEND
	IF IN% = 6 OR IN% = 0 THEN EXIT SUB
	IF IN% = 1 THEN GOSUB add
	IF IN% = 2 THEN GOSUB SEC
	IF IN% = 3 THEN GOSUB SETPATH
	IF IN% = 4 THEN GOSUB CHGWFM
	IF IN% = 5 THEN GOSUB CHGSET
	GOTO prog1
add:
		PRINT : PRINT "Enter new primary address (0-30), or press <Enter> to keep at" + STR$(PRI%);
		INPUT num$
		IF LEN(num$) = 0 THEN RETURN
		num% = VAL(num$ + "BAD-99")
		IF num% < 0 OR num% > 30 THEN GOTO add
		PRI% = num%
		CALL IBPAD(DIG, PRI%)
		RETURN
SEC:
		PRINT : PRINT "Enter new secondary address (0-30), or press <Enter> to keep at" + STR$(PRI%);
		INPUT num$
		IF LEN(num$) = 0 THEN RETURN
		num% = VAL(num$ + "BAD-99")
		IF num% < 0 OR num% > 30 THEN GOTO add
		SEC% = num%
		CALL IBSAD(DIG, SEC%)
		RETURN
SETPATH:
		tstorpath$ = SPACE$(50)
		PRINT
		PRINT "Enter new path, currently: " + STORPATH$ + " or <Enter> to keep"
		INPUT tstorpath$
		IF LEN(tstorpath$) = 0 THEN RETURN
		STORPATH$ = RTRIM$(tstorpath$)
		RETURN
CHGWFM:
		tfilename$ = SPACE$(10)
		PRINT
		PRINT "Enter new waveform filename, currently: " + WFMNAME$
		PRINT "Press <Enter> to keep or type new filename"
		INPUT tfilename$
		IF LEN(tfilename$) = 0 THEN RETURN
		WFMNAME$ = RTRIM$(tfilename$)
		a% = INSTR(filenam$, ".")
		IF a% = 0 THEN WFMNAME$ = WFMNAME$ + "."
		RETURN
CHGSET:
		tfilename$ = SPACE$(10)
		PRINT
		PRINT "Enter new settings filename, currently: " + SETNAME$
		PRINT "Press <Enter> to keep or type new filename"
		INPUT tfilename$
		IF LEN(tfilename$) = 0 THEN RETURN
		SETNAME$ = RTRIM$(tfilename$)
		a% = INSTR(filenam$, ".")
		IF a% = 0 THEN SETNAME$ = SETNAME$ + "."
		RETURN

END SUB

SUB REMOVE.DEFECT (DIG)
	PRINT : PRINT "Removing any defects from 7912HB CRT";
	CALL IBSAD(DIG, 96 + 0)
	CALL GPIB.WRITE(DIG, "DIG DEF,1024;DEF ON", FLAG)
	OPC% = 0
	WHILE OPC% < 1
		CALL WAIT.FOR.OPC(DIG, OPC%)
	WEND
	CALL GPIB.WRITE(DIG, "XYZ ATC;DIG DAT;ATC", FLAG)
END SUB

SUB ROUND (N#, p#) STATIC          ' round n# to nearest precision p#
		m# = N# / p#
		m$ = STR$(m# + .5 * SGN(m#))' add .5 for rounding
		d% = INSTR(m$, "D")         ' CINT would be simpler but would
		IF d% > 0 THEN              ' result in OVERFLOW errors unless
			E$ = MID$(m$, d%)      ' n# and p# were restricted such that
		ELSE                        ' -32768.5  <  (n#/p#)  <  32767.5
			E$ = ""                ' This would severely limit the
		END IF                      ' the usefulness of this SUB with
		d% = INSTR(m$, ".")         ' long record length and high vertical
		IF d% > 0 THEN              '      resolution digitizers...
			m$ = LEFT$(m$, d% - 1) + E$
		END IF
		N# = VAL(m$) * p#
END SUB

SUB SCALEWFM (YM!, YZ%, WFM(), IWFM%())
'SUB TO SCALE THE INTEGER ARRAY IWFM$() INTO A VOLTAGE ARRAY WFM()
'USING THE YMULITPLIER 'YM!' AND THE GROUND REFERENCE 'YZ%' (IF DEFINED)

	PRINT "Scaling waveform into a voltage array"
	IF YZ% > -1 THEN YZERO% = YZ% ELSE YZERO% = 0  'IF GND REF DEFINED THEN USE
	FOR I% = 0 TO 511
		WFM(I%) = IWFM%(I%) * YM!
	NEXT I%
END SUB

SUB SRQ (DIG, STATUS%(), pause%)
' Sub to clear srq's from the mainframe, vert plugin, and timebase plugin
   FOR I% = 0 TO 2
	CALL IBSAD(DIG, 96 + I%)
	CALL IBRSP(DIG, STATUS%(I%))
	IF IBSTA% < 0 THEN
		FLAG = FALSE
		CALL PRESS.ANY.KEY("ERROR HANDLING SRQ, IBSTA= $" + HEX$(IBSTA%) + ", IBERR=" + STR$(IBERR%) + ", IBCNT=" + STR$(IBCNT%))
		IBERR% = 0
	END IF
   NEXT I%
   IF pause% = 1 THEN
   CALL PRESS.ANY.KEY("MAINFRAME SRQ:" + STR$(STATUS%(0)) + ", VERTICAL PLUGGIN SRQ:" + STR$(STATUS%(1)) + ", TIMEBASE SRQ:" + STR$(STATUS%(2)))
   END IF
END SUB

SUB STORE.RECALL.SET (SETNAME$)
' Learn mainframe, vert & timebase plug-in settings & store to disk
	filename$ = STORPATH$ + SETNAME$ + "."
	a$ = SPACE$(1)
   WHILE a$ <> "R" AND a$ <> "S" AND a$ <> "E"
	PRINT : INPUT "Store or Recall 7912HB/vert/timbase settings (Enter S, R, or E for exit):", a$
	a$ = UCASE$(a$)
   WEND
   IF a$ = "E" THEN EXIT SUB
   IF a$ = "S" THEN TMP$ = "save" ELSE TMP$ = "send"
   filenum% = 0
WHILE filenum% < 1 OR filenum% > 100
   filenum% = GETNUM%("Enter file number (1 to 100)")
WEND
   filename$ = filename$ + MID$(STR$(filenum%), 2, 4)
   IF a$ = "S" THEN
	OPEN filename$ FOR OUTPUT AS #1
   ELSE
	OPEN filename$ FOR INPUT AS #1
   END IF
	FOR I% = 0 TO 2
		CALL IBSAD(DIG, 96 + I%)
		IF a$ = "S" THEN
			RD$ = SPACE$(100)
			CALL GPIB.WRITE(DIG, "SET?", FLAG)
			IF FLAG = FALSE THEN GOSUB errorset
			CALL GPIB.READ(DIG, RD$, FLAG)
			IF FLAG = FALSE THEN GOSUB errorset
			RD$ = RTRIM$(RD$)
			PRINT #1, RD$
		ELSE
			INPUT #1, RD$
			CALL GPIB.WRITE(DIG, RD$, FLAG)
			IF FLAG = FALSE THEN GOSUB errorset
		END IF
	NEXT I%
	CLOSE
	'CALL GTL
	CALL PRESS.ANY.KEY("Settings transfer complete")
	EXIT SUB
errorset:
	CALL PRESS.ANY.KEY("Error when trying to " + TMP$ + " settings to/from 7912HB")
	EXIT SUB
END SUB

FUNCTION STR2NUM (source$, SRCH$)
' FUNCTION TO RETURN A NUMBER FROM A STRING.  USEFUL FOR PARSING WAVEFORM
' PREAMBLE FOR VALUES
'       DIM STR2NUM AS LONG
	STATIC POSIT%, TMP$
	POSIT% = INSTR(source$, SRCH$) + LEN(SRCH$) + 1
	TMP$ = MID$(source$, POSIT%, 15)
	STR2NUM = VAL(TMP$)

END FUNCTION

SUB SWAP.BYTES (test%()) STATIC

' Swaps high and low bytes of an integer number
	FOR I = 0 TO 511
	tempbyte% = test%(I) AND &HFF00
	IF tempbyte% < 0 THEN
		tempbyte% = ((tempbyte% AND &H7F00) \ 256) OR &H80
	ELSE
		tempbyte% = tempbyte% \ 256
	END IF
	test%(I) = ((test%(I) AND &HFF) * 256) + tempbyte%
	NEXT I
END SUB

SUB WAIT.FOR.OPC (DIG, OPC%)
	STAT% = 0       'WAIT TILL 7912 IS READY TO SEND WAVEFORM
			'WAIT FOR OPC (OPERATION COMPLETE)
	CALL IBRSP(DIG, STAT%)
	IF STAT% <> 66 AND STAT% <> 2 AND STAT% <> 82 AND STAT% <> 18 THEN
		OPC% = 0
		PRINT ".";
		CALL DELAY(.1)
	ELSE
		OPC% = 1
		PRINT
	END IF
END SUB

SUB WAIT.KEY (KEY$) STATIC

	WHILE INKEY$ > ""    ' flush out pending keystrokes
	WEND
	DO
		KEY$ = INKEY$
	LOOP UNTIL KEY$ > ""
END SUB

